<%@ Assembly Name="Dialog, Version=1.0.0.0, Culture=neutral, PublicKeyToken=baccae72ff1d30ee" %>
<%@ Assembly Name="Microsoft.Web.CommandUI, Version=14.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c" %> 
<%@ Register Tagprefix="SharePoint" Namespace="Microsoft.SharePoint.WebControls" Assembly="Microsoft.SharePoint, Version=14.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c" %> 
<%@ Register Tagprefix="Utilities" Namespace="Microsoft.SharePoint.Utilities" Assembly="Microsoft.SharePoint, Version=14.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c" %>
<%@ Register Tagprefix="asp" Namespace="System.Web.UI" Assembly="System.Web.Extensions, Version=3.5.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35" %>
<%@ Import Namespace="Microsoft.SharePoint" %> 
<%@ Register Tagprefix="WebPartPages" Namespace="Microsoft.SharePoint.WebPartPages" Assembly="Microsoft.SharePoint, Version=14.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c" %>
<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DialogUserControl.ascx.cs" Inherits="Dialog.Dialog.DialogUserControl" %>
<input onclick="OpenDialog()" type="button" 
       value="Dialog öffnen"/>

<script type="text/javascript">

    var notifyId;

    function OpenDialog() {
        notifyId = SP.UI.Notify.addNotification("Öffne Dialog", true);
        var options = {
            url: SP.Utilities.Utility.getLayoutsPageUrl('dialog.htm'),
            width: 400,
            height: 300,
            title: "Mein Dialog",
            dialogReturnValueCallback: onDialogClose
        };
        SP.UI.ModalDialog.showModalDialog(options);
    }

    function onDialogClose(result, returnValue) {
        SP.UI.Notify.removeNotification(notifyId);

        if (result == SP.UI.DialogResult.OK) {
            notifyId = SP.UI.Notify.addNotification("OK:" + returnValue, false);
        }
        else if (result == SP.UI.DialogResult.cancel) {
            notifyId = SP.UI.Notify.addNotification("Abgebrochen:" + result, false);
        }
    }
</script>
